unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, jpeg, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Image1DblClick(Sender: TObject);
  private
    { Private declarations }
    procedure ZapiszObrazDoPliku(Sender: TObject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var NazwaPliku :String;
begin
if ParamCount>0 then
  begin
  NazwaPliku:=ParamStr(1);
  if FileExists(NazwaPliku) then
    begin
    Memo1.Lines.LoadFromFile(NazwaPliku);
    Self.Caption:=NazwaPliku;
    end
    else ShowMessage('Plik '+NazwaPliku+' nie istnieje!');
  end;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
case Key of
  VK_ESCAPE: Close();
  VK_F11: Image1DblClick(Sender);
  VK_F12: ZapiszObrazDoPliku(Sender);
end;
end;

procedure TForm1.Image1DblClick(Sender: TObject);
begin
if OpenDialog1.Execute then
  begin
  Memo1.Lines.LoadFromFile(OpenDialog1.FileName);
  Form1.Caption:=OpenDialog1.FileName;
  end;
end;

procedure TForm1.ZapiszObrazDoPliku(Sender: TObject);
begin
SaveDialog1.DefaultExt:=ExtractFileExt(OpenDialog1.FileName);
SaveDialog1.Filename:=OpenDialog1.FileName;
if (SaveDialog1.Execute) then
  begin
  Memo1.Lines.SaveToFile(SaveDialog1.FileName);
  Form1.Caption:=SaveDialog1.FileName;
  end;
end;

end.
